#include maps\mp\gametypes\_hud_util;
#include maps\mp\_utility;
#include common_scripts\utility;
#include user_scripts\mp_patches\forge\preload;

roundUp(floatVal) {
  if (int(floatVal) != floatVal)
    return int(floatVal + 1);
  else
    return int(floatVal);
}

StartWall(){self thread BuildStructure(::CreateWalls, "Wall", "CreateWalls");}
StartGrid(){self thread BuildStructure(::CreateGrids, "Grid", "CreateGrids");}
StartRamp(){self thread BuildStructure(::CreateRamps, "Ramp", "CreateRamps");}
StartDoor(){self thread BuildDoor(::CreateDoors, "Door", "CreateDoors", (90, 0, 0), 3, 2, 100, 75);}
StartTele(){self thread BuildStructure(::CreateElevator, "Teleporters", "CreateElevator");}
StartForce(){self thread BuildStructure(::CreateForce, "ForceField", "CreateForce");}

//Destroy
DestroyOnDeath(text){self waittill("death");text destroy();}
DestroyOnCancel(text,not){self waittill(not);text destroy();}
endOnCancel(not,gun){self notifyOnPlayerCommand( "canc", "+actionslot 4" );for(;;){self waittill("canc");self notify(not);gun delete();}}

BuildForge(){
	if(!self.Forge){
		self notify("StopForge");
		self.Forge=1;
		self iprintln("Spawn Editor Mode Enabled");
		self thread PickupCrate();
		self thread SpawnCrate();
	} 
	else{
		self notify("StopForge");
		self.Forge=0;
		self iprintln("Spawn Editor Mode Disabled");
	}
}

showForgeText(var_0){
	if(var_0){
		if(!isDefined(self.forgeText)){
			self.forgeText = self createFontString("default", 0.8);
			self.forgeText setPoint( "TOP LEFT", "TOP LEFT", 130, 20);
			self.forgeText.color = ((50/255),(20/255),(255/255));
			self.forgeText.alpha = 1;
			self.forgeText setText("[{+actionslot 2}] - Spawn Model\n[{+usereload}] - Move and Drop a Model\n[{+melee_zoom}] - Change Angle Mode\n[{+frag}]/[{+smoke}] - Rotate Model\n[{weapnext}] - Freeze Model\n[{+attack}]/[{+speed_throw}] - Move Model Closer or Further");
		}
	}
	else{
		if(isDefined(self.forgeText))
			self.forgeText destroy();
	}
}

SpawnCrate(model){
	self endon("death");
	self endon("StopForge");
	self notifyOnPlayerCommand( "dpad_down", "+actionslot 2" );
	for(;;){
		self waittill("dpad_down");
		if(self.ugp>0){
			vec=anglestoforward(self getPlayerAngles());
			end=(vec[0]*200,vec[1]*200,vec[2]*200);
			L=BulletTrace(self gettagorigin("tag_eye"),
			self gettagorigin("tag_eye")+end,0,self)["position"];
			c=spawn("script_model",L+(0,0,20));
			c CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
			c setModel(level.SpawnEditorModel);
			//c PhysicsLaunchServer((0,0,0),(0,0,0));
			c.angles=self.angles+(0,90,0);self.ugp--;
		}
	}
}

PickupCrate(){
	self endon("death");
	self endon("StopForge");
	self notifyOnPlayerCommand("square","+usereload");
	for(;;){
		self waittill("square");
		vec=anglestoforward(self getPlayerAngles());
		end=(vec[0]*100,vec[1]*100,vec[2]*100);
		entity=BulletTrace(self gettagorigin("tag_eye"),self gettagorigin("tag_eye")+(vec[0]*1000,vec[1]*1000,vec[2]*1000),0,self)["entity"];
		if(isdefined(entity.model)){
			self thread MoveCrate(entity);
			self thread showForgeText(true);
			self waittill("square");
			self thread showForgeText(false);
			self.moveSpeedScaler=1;
			self maps\mp\gametypes\_weapons::updateMoveSpeedScale("primary");
			self.inEditing = false;
			self.EditLock = false;
			logprint("\n\n"+"SpawnModel(\""+level.SpawnEditorModel+"\","+entity.origin+","+entity.angles+");"+"\n\n");
			self _giveWeapon(self.oldWeapon);
			wait 1;
			self switchtoweapon(self.oldWeapon);
			self notifyOnPlayerCommand("canc","+actionslot 4");
		}
	}
}
MoveCrate(entity){
	self endon("square");
	self.inEditing = true;
	self.EditLock = false;
	self.editOption = 1;
	angle1 = 0;
	if(!isDefined(self.entDist))
		self.entDist = 200;
	if(!isDefined(self.tempDist))
		self.tempDist = 200;
	self.oldWeapon = self getCurrentWeapon();
	self takeAllWeapons();
	for(;;){
		if(self FragButtonPressed() && !self.menuIsOpen){
			if(self.editOption == 0)
				entity.angles=(angle1, entity.angles[1], entity.angles[2]);
			if(self.editOption == 1)
				entity.angles=(entity.angles[0], angle1, entity.angles[2]);
			if(self.editOption == 2)
				entity.angles=(entity.angles[0], entity.angles[1], angle1);
			angle1 -= 1.0;
		}
		else if(self SecondaryOffhandButtonPressed() && !self.menuIsOpen){
			if(self.editOption == 0)
				entity.angles=(angle1, entity.angles[1], entity.angles[2]);
			if(self.editOption == 1)
				entity.angles=(entity.angles[0], angle1, entity.angles[2]);
			if(self.editOption == 2)
				entity.angles=(entity.angles[0], entity.angles[1], angle1);
			angle1 += 1.0;
		}
		else if(self isButtonPressed("weapnext") && !self.menuIsOpen){
			if(self.EditLock)
				self.EditLock = 0;
			else if(!self.EditLock)
				self.EditLock = 1;
			iprintlnBold("EditLock: "+self.EditLock);
		}
		else if(self attackButtonPressed() && !self.menuIsOpen){
			if(self.entDist > 500)
				self.entDist = 50;
			else if(self.entDist < 50)
				self.entDist = 500;
			else
				self.entDist++;
		}
		else if(self ADSButtonPressed() && !self.menuIsOpen){
			if(self.entDist > 500)
				self.entDist = 50;
			else if(self.entDist < 50)
				self.entDist = 500;
			else
				self.entDist--;
		}
		else if(self isButtonPressed("+melee_zoom") && !self.menuIsOpen){
			self.editOption++;
			if(self.editOption > 2)
				self.editOption = 0;
			

			if(self.editOption == 0){
				angle1=entity.angles[0];
			}
			else if(self.editOption == 1){
				angle1=entity.angles[1];
			}
			else if(self.editOption == 2){
				angle1=entity.angles[2];
			}
			iprintlnBold("Edit Option: "+self.editOption);
		}
		//entity.angles[0]=self.angles[0];
		//entity.angles[1]=self.angles[1];
		//entity.angles[2]=self.angles[2];
		vec=anglestoforward(self getPlayerAngles());
		end=(vec[0]*self.entDist,vec[1]*self.entDist,vec[2]*self.entDist);
		if(!self.EditLock){
			entity.origin=(self gettagorigin("tag_eye")+end);
			self.tempDist = self.entDist;
		}
		//self.moveSpeedScaler=0.5;
		//self maps\mp\gametypes\_weapons::updateMoveSpeedScale("primary");
		wait 0.01;
	}
}

CreateTeleport2(enter, exit, distRange)
{
	self endon("disconnect");
	while(1)
	{
		foreach(player in level.players)
		{
			if(Distance(enter, player.origin) <= distRange){
				player setorigin((exit));
			}
		}
		wait 0.025;
	}
}

BuildStructure(function, type, functiontype) {
  self endon("jw");
  self endon("death");
  instruct1 = self createFontString("hudbig", 1);
  instruct1 setPoint("TOP");
  instruct1 setText("^2Press [{+actionslot 2}] to Start Your " + type);
  cancel = self createFontString("hudbig", 1);
  cancel setPoint("BOTTOM");
  cancel setText("^2Press [{+actionslot 4}] to Cancel");
  self thread DestroyOnCancel(instruct1, "jw");
  self thread DestroyOnCancel(cancel, "jw");
  self thread DestroyOnDeath(cancel);
  self thread DestroyOnDeath(instruct1);
  self thread endOnCancel("jw");
  self notifyOnPlayerCommand("SL", "+actionslot 2");
  for (;;) {
    self waittill("SL");
    start = self GetOrigin();
    self iPrintLnBold("Start Position Saved.");
    instruct1 destroy();
    instruct2 = self createFontString("hudbig", 1);
    instruct2 setPoint("TOP");
    instruct2 setText("^2Press [{+actionslot 2}] to Finish Your " + type);
    self thread DestroyOnCancel(instruct2, "jw");
    self thread DestroyOnDeath(instruct2);
    self waittill("SL");
    end = self GetOrigin();
    self iPrintLnBold("End Position Saved.");
    instruct2 destroy();
    instruct3 = self createFontString("hudbig", 1);
    instruct3 setPoint("TOP");
    instruct3 setText("^2Press [{+actionslot 2}] to Build Your " + type);
    self thread DestroyOnCancel(instruct3, "jw");
    self thread DestroyOnDeath(instruct3);
	angle = self.angles;
    self waittill("SL");
    instruct3 destroy();
    cancel destroy();
    self iPrintLnBold("Building " + type + "......");
    wait 1;
    self iPrintLnBold("Building " + type + "......");
    wait 1;
    self iPrintLnBold("Building " + type + "......");
    [[function]] (start, end, angle);
    self iPrintLnBold(type + " Built.");
    wait 1;
    self iPrintLnBold("Press [{+actionslot 2}] to Dismiss The Following Message");
	if(type == "Teleporters")
    	logprint("\n\n\n\n\nYOUR CODE IS HERE ("+getdvar("mapname")+"):\n---------------------------------------------------------------\n\n\n"+functiontype+"("+start+","+end+"),("+angle+");\n\n\n\n------------------------------------------------------------------");
	else
		logprint("\n\n\n\n\nYOUR CODE IS HERE ("+getdvar("mapname")+"):\n---------------------------------------------------------------\n\n\n"+functiontype+"("+start+","+end+");\n\n\n\n------------------------------------------------------------------");
    instruct7 = self createFontString("hudbig", 1.2);
    instruct7 setPoint("TOP");
    instruct7 setText("");
    self thread DestroyOnDeath(instruct7);
    self waittill("SL");
    instruct7 destroy();
    self notify("jw");
  }
}

createFlag(pos){
	level.flagPreSpawn = spawn( "script_model", pos );
	level.CaptureStatus["allies"] = 0;
	level.CaptureStatus["axis"] = 0;
	level.TeamOnFlag["allies"] = 0;
	level.TeamOnFlag["axis"] = 0;
	level.flag = spawn( "script_model", pos );
	level.flag setModel( "prop_flag_neutral" );
}

SpawnModel(Model, Location, andles) {
  self endon("disconnect");
  Obj = spawn("script_model", Location);
  Obj PhysicsLaunchServer((0, 0, 0), (0, 0, 0));
  Obj.angles = andles;
  Obj setModel(Model);
}

BuildDoor(function,type,functiontype,angle,size,height,hp,range){self endon("cw");self endon("death");instruct1=self createFontString("hudbig",1);instruct1 setPoint("TOP");instruct1 setText("^2Press [{+actionslot 2}] to Start Your "+type);cancel=self createFontString("hudbig",1);cancel setPoint("BOTTOM");cancel setText("^2Press [{+actionslot 4}] to Cancel");self thread DestroyOnCancel(instruct1,"cw");self thread DestroyOnCancel(cancel,"cw");self thread DestroyOnDeath(cancel);self thread DestroyOnDeath(instruct1);self thread endOnCancel("cw");self notifyOnPlayerCommand("SL","+actionslot 2");for(;;){self waittill("SL");start=self GetOrigin();self iPrintLnBold("Start Position Saved.");instruct1 destroy();instruct2=self createFontString("hudbig",1);instruct2 setPoint("TOP");instruct2 setText("^2Press [{+actionslot 2}] to Start Your "+type);self thread DestroyOnDeath(instruct2);self waittill("SL");end=self GetOrigin();self iPrintLnBold("End Position Saved.");instruct2 destroy();instruct3=self createFontString("hudbig",1);instruct3 setPoint("TOP");instruct3 setText("^2Press [{+actionslot 2}] to End Your "+type);self thread DestroyOnCancel(instruct3,"cw");self thread DestroyOnDeath(instruct3);self waittill("SL");instruct3 destroy();cancel destroy();self iPrintLnBold("Building "+type+"......");wait 1;self iPrintLnBold("Building "+type+"......");wait 1;self iPrintLnBold("Building "+type+"......");[[function]](start,end,angle,size,height,hp,range);self iPrintLnBold(type+" Built.");wait 1;self iPrintLnBold("Press [{+actionslot 2}] to Dismiss The Following Message");logprint("\n\n\n\n\nYOUR CODE IS HERE:\n---------------------------------------------------------------\n\n\n"+functiontype+"("+start+","+end+","+angle+","+size+","+height+","+hp+","+range+");\n\n\n\n------------------------------------------------------------------");instruct7=self createFontString("hudbig",1.2);instruct7 setPoint("TOP");instruct7 setText("");self thread DestroyOnDeath(instruct7);self waittill("SL");instruct7 destroy();self.plat=0;self notify("cw");}} 

CreateForce(start,end){D=Distance((start[0],start[1],0),(end[0],end[1],0));H=Distance((0,0,start[2]),(0,0,end[2]));blocks=roundUp(D/55);height=roundUp(H/30);CX=end[0] - start[0];CY=end[1] - start[1];CZ=end[2] - start[2];XA =(CX/blocks);YA =(CY/blocks);ZA =(CZ/height);TXA =(XA/4);TYA =(YA/4);Temp=VectorToAngles(end - start);Angle =(0,Temp[1],90);for(h=0;h < height;h++){block=spawn("script_model",(start +(TXA,TYA,10)+((0,0,ZA)* h)));block setModel(level.chopper_fx["light"]["belly"]);block.angles=Angle;block Solid();block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);for(i=1;i < blocks;i++){block=spawn("script_model",(start +((XA,YA,0)* i)+(0,0,10)+((0,0,ZA)* h)));block setModel(level.chopper_fx["light"]["belly"]);block.angles=Angle;block Solid();block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);}block=spawn("script_model",((end[0],end[1],start[2])+(TXA * -1,TYA * -1,10)+((0,0,ZA)* h)));block setModel(level.chopper_fx["light"]["belly"]);block.angles=Angle;block Solid();block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);}}

CreateElevator(enter, exit, angle) {
  flag = spawn("script_model", enter);
  flag setModel("h1_flag_mp_domination_usmc_blue");
  playFX(level.RaygunFX[ "impact" ], flag.origin);
  wait 0.01;
  flag = spawn("script_model", exit);
  flag setModel("h1_flag_mp_domination_usmc_red");
  wait 0.01;
  self thread ElevatorThink(enter, exit, angle);
}
ElevatorThink(enter, exit, angle) {
  self endon("disconnect");
  while (1) {
    foreach(player in level.players) {
      if (Distance(enter, player.origin) <= 50) {
        player SetOrigin(exit);
        player SetPlayerAngles(angle);
      }
    }
    wait .25;
  }
}
CreateDoors(open,close,angle,size,height,hp,range){ offset =(((size / 2)- 0.5)* -1); center=spawn("script_model",open); for(j=0;j < size;j++){ door=spawn("script_model",open +((0,30,0)* offset)); door setModel("com_plasticcase_enemy"); door Solid(); door CloneBrushmodelToScriptmodel(level.airDropCrateCollision); door EnableLinkTo(); door LinkTo(center); for(h=1;h < height;h++){ door=spawn("script_model",open +((0,30,0)* offset)-((70,0,0)* h)); door setModel("com_plasticcase_enemy"); door Solid(); door CloneBrushmodelToScriptmodel(level.airDropCrateCollision); door EnableLinkTo(); door LinkTo(center); } offset += 1; } center.angles=angle; center.state="open"; center.hp=hp; center.range=range; center thread DoorThink(open,close); center thread DoorUse(); center thread ResetDoors(open,hp); wait 0.01;} DoorThink(open,close){ while(1) { if(self.hp > 0){ self waittill("triggeruse" ,player); if(player.team=="allies"){ if(self.state=="open"){ self MoveTo(close,level.doorwait); wait level.doorwait; self.state="close"; continue; } if(self.state=="close"){ self MoveTo(open,level.doorwait); wait level.doorwait; self.state="open"; continue; } } if(player.team=="axis"){ if(self.state=="close"){ self.hp--; player iPrintlnBold("HIT"); wait 1; continue; } } }else{ if(self.state=="close"){ self MoveTo(open,level.doorwait); } self.state="broken"; wait .5; } }} DoorUse(range){ self endon("disconnect"); while(1) { foreach(player in level.players) { if(Distance(self.origin,player.origin)<= self.range){ if(player.team=="allies"){ if(self.state=="open"){ player.hint="Press ^3[{+activate}] ^7to ^2Close ^7the door"; } if(self.state=="close"){ player.hint="Press ^3[{+activate}] ^7to ^2Open ^7the door"; } if(self.state=="broken"){ player.hint="^1Door is Broken"; } } if(player.team=="axis"){ if(self.state=="close"){ player.hint="Press ^3[{+activate}] ^7to ^2Attack ^7the door"; } if(self.state=="broken"){ player.hint="^1Door is Broken"; } } if(player.buttonPressed[ "+activate" ]==1){ player.buttonPressed[ "+activate" ]=0; self notify("triggeruse" ,player); } } } wait .045; }} ResetDoors(open,hp){ while(1) { level waittill("RESETDOORS"); self.hp=hp; self MoveTo(open,level.doorwait); self.state="open"; }}

CreateRamps(top, bottom) {
  D = Distance(top, bottom);
  blocks = roundUp(D / 30);
  CX = top[0] - bottom[0];
  CY = top[1] - bottom[1];
  CZ = top[2] - bottom[2];
  XA = CX / blocks;
  YA = CY / blocks;
  ZA = CZ / blocks;
  CXY = Distance((top[0], top[1], 0), (bottom[0], bottom[1], 0));
  Temp = VectorToAngles(top - bottom);
  BA = (Temp[2], Temp[1] + 90, Temp[0]);
  for (b = 0; b < blocks; b++) {
    block = spawn("script_model", (bottom + ((XA, YA, ZA) * B)));
    block setModel("com_plasticcase_friendly");
    block.angles = BA;
    block Solid();
    block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    wait 0.01;
  }
  block = spawn("script_model", (bottom + ((XA, YA, ZA) * blocks) - (0, 0, 5)));
  block setModel("com_plasticcase_friendly");
  block.angles = (BA[0], BA[1], 0);
  block Solid();
  block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
  wait 0.01;
}

CreateWalls(start, end) {
  D = Distance((start[0], start[1], 0), (end[0], end[1], 0));
  H = Distance((0, 0, start[2]), (0, 0, end[2]));
  blocks = roundUp(D / 55);
  height = roundUp(H / 30);
  CX = end[0] - start[0];
  CY = end[1] - start[1];
  CZ = end[2] - start[2];
  XA = (CX / blocks);
  YA = (CY / blocks);
  ZA = (CZ / height);
  TXA = (XA / 4);
  TYA = (YA / 4);
  Temp = VectorToAngles(end - start);
  Angle = (0, Temp[1], 90);
  for (h = 0; h < height; h++) {
    block = spawn("script_model", (start + (TXA, TYA, 10) + ((0, 0, ZA) * h)));
    block setModel("com_plasticcase_friendly");
    block.angles = Angle;
    block Solid();
    block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    for (i = 1; i < blocks; i++) {
      block = spawn("script_model", (start + ((XA, YA, 0) * i) + (0, 0, 10) +
                                     ((0, 0, ZA) * h)));
      block setModel("com_plasticcase_friendly");
      block.angles = Angle;
      block Solid();
      block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    }
    block =
        spawn("script_model", ((end[0], end[1], start[2]) +
                               (TXA * -1, TYA * -1, 10) + ((0, 0, ZA) * h)));
    block setModel("com_plasticcase_friendly");
    block.angles = Angle;
    block Solid();
    block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
  }
}
CreateGrids(corner1, corner2, angle) {
  W = Distance((corner1[0], 0, 0), (corner2[0], 0, 0));
  L = Distance((0, corner1[1], 0), (0, corner2[1], 0));
  H = Distance((0, 0, corner1[2]), (0, 0, corner2[2]));
  CX = corner2[0] - corner1[0];
  CY = corner2[1] - corner1[1];
  CZ = corner2[2] - corner1[2];
  ROWS = roundUp(W / 55);
  COLUMNS = roundUp(L / 30);
  HEIGHT = roundUp(H / 20);
  XA = CX / ROWS;
  YA = CY / COLUMNS;
  ZA = CZ / HEIGHT;
  center = spawn("script_model", corner1);
  for (r = 0; r <= ROWS; r++) {
    for (c = 0; c <= COLUMNS; c++) {
      for (h = 0; h <= HEIGHT; h++) {
        block = spawn("script_model", (corner1 + (XA * r, YA * c, ZA * h)));
        block setModel("com_plasticcase_friendly");
        block.angles = (0, 0, 0);
        block Solid();
        block LinkTo(center);
        block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
        wait 0.01;
      }
    }
  }
  center.angles = angle;
}


CreateModel(pos, angle, model)
{
	PrecacheModel(model);
	block = spawn("script_model", pos );
	block setModel(model);
	block.angles = angle;
	block Solid();
	wait 0.01;
}
CreateBlocks(pos, angle)
{
	block = spawn("script_model", pos );
	block setModel("com_plasticcase_friendly");
	block.angles = angle;
	block Solid();
	block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
	wait 0.01;
}
CreateHiddenBlocks(pos, angle)
{
	block = spawn("script_model", pos );
	block setModel("com_plasticcase_friendly");
	block.angles = angle;
	block hide();
	block Solid();
	block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
	wait 0.01;
}
CreateHiddenWalls(start,end)
{
	D=Distance((start[0],start[1],0),(end[0],end[1],0));
	H=Distance((0,0,start[2]),(0,0,end[2]));
	blocks=roundUp(D/55);
	height=roundUp(H/30);
	CX=end[0] - start[0];
	CY=end[1] - start[1];
	CZ=end[2] - start[2];
	XA =(CX/blocks);
	YA =(CY/blocks);
	ZA =(CZ/height);
	TXA =(XA/4);
	TYA =(YA/4);
	Temp=VectorToAngles(end - start);
	Angle =(0,Temp[1],90);
	for(h=0;h < height;h++)
	{
		block=spawn("script_model",(start +(TXA,TYA,10)+((0,0,ZA)* h)));
		block setModel("com_plasticcase_friendly");
		block.angles=Angle;
		block Solid();
		block hide();
		block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
		
		for(i=1;i < blocks;i++)
		{
			block=spawn("script_model",(start +((XA,YA,0)* i)+(0,0,10)+((0,0,ZA)* h)));
			block setModel("com_plasticcase_friendly");
			block.angles=Angle;
			block Solid();
			block hide();
			block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
			
		}
		block=spawn("script_model",((end[0],end[1],start[2])+(TXA * -1,TYA * -1,10)+((0,0,ZA)* h)));
		block setModel("com_plasticcase_friendly");
		block.angles=Angle;
		block Solid();
		block hide();
		block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
		
	}
	
	level notify("Level_DBBuilt");
	level.Level_DBBuilt=1;
}
CreateWalls3(start,end){
D=Distance((start[0],start[1],0),(end[0],end[1],0));
H=Distance((0,0,start[2]),(0,0,end[2]));
blocks=roundUp(D/55);
height=roundUp(H/30);
CX=end[0] - start[0];
CY=end[1] - start[1];
CZ=end[2] - start[2];
XA =(CX/blocks);YA =(CY/blocks);
ZA =(CZ/height);TXA =(XA/4);
TYA =(YA/4);
Temp=VectorToAngles(end - start);
Angle =(0,Temp[1],90);
for(h=0;h < height;h++)
{
block=spawn("script_model",(start +(TXA,TYA,10)+((0,0,ZA)* h)));
block setModel("com_plasticcase_beige_big");
block.angles=Angle;block Solid();
block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
for(i=1;i < blocks;i++){block=spawn("script_model",(start +((XA,YA,0)* i)+(0,0,10)+((0,0,ZA)* h)));
block setModel("com_plasticcase_beige_big");block.angles=Angle;block Solid();block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
}
block=spawn("script_model",((end[0],end[1],start[2])+(TXA * -1,TYA * -1,10)+((0,0,ZA)* h)));
block setModel("com_plasticcase_beige_big");
block.angles=Angle;block Solid();
block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
}
}